#lang racket/gui

; --- imports ---
(require "constants.rkt")
(require pict pict/shadow)

; --- exports ---
(provide about-dialog%)

; --- body ---
(define my-canvas%
  (class canvas%
    ;(define background-color-initial (make-color 213 229 255))
    ;(define shadow-color-initial (make-color 0 68 170))
    ;(define background-color (make-object color% background-color-initial))
    ;(define shadow-color (make-object color% shadow-color-initial))
    (define background-color (make-color 213 229 255))
    (define shadow-color (make-color 0 68 170))
    (define scale-factor 1.0)
    (define scale-delta 0.01)
    (define pos-x-delta 0.0)
    (define pos-y-delta 0.0)
    (define logo-font (make-font #:size 24 #:family 'swiss #:face "Arial, Helvetica" #:weight 'bold)) ; font family is fallback
    (define logo (let ([shadow-radius 10]) (inset (shadow (text "A-IDE" logo-font) shadow-radius 0 0 #:color background-color #:shadow-color shadow-color) shadow-radius)))
    (super-new [style '(transparent no-focus)] [stretchable-height #f] [min-height (inexact->exact (pict-height logo))]
               [paint-callback (lambda (canvas dc)
                                 (let-values ([(dc-width dc-height) (send dc get-size)])
                                   (let ([scaled-logo (scale logo scale-factor)])
                                     (draw-pict scaled-logo dc
                                                (+ (- (/ dc-width 2) (/ (pict-width scaled-logo) 2)) pos-x-delta)
                                                (+ (- (/ dc-height 2) (/ (pict-height scaled-logo) 2)) pos-y-delta)
                                                ))))])

    ; - methods -
    (define/override (on-event e)
      (if (send e button-changed?)
          ; mouse click: translate
          (let ([event-x (send e get-x)] [event-y (send e get-y)] [dc (send this get-dc)])
            (let-values ([(dc-width dc-height) (send dc get-size)])
              (set! pos-x-delta (- event-x (/ dc-width 2)))
              (set! pos-y-delta (- event-y (/ dc-height 2)))))
          ; mouse move: scale
          (begin
            (when (or (< scale-factor 1.0) (> scale-factor 2.0))
              (set! scale-delta (- scale-delta)))
            (set! scale-factor (+ scale-factor scale-delta))))
      ;(send shadow-color set
      ;      (modulo (add1 (send shadow-color red)) 256)
      ;      (modulo (add1 (send shadow-color green)) 256)
      ;      (modulo (add1 (send shadow-color blue)) 256))
      (send this refresh)) ;(send this refresh-now) ; for some reason, the canvas loses its transparency after refresh-now (probably, 'erase' is to blame)

    (define/public (reset-logo)
      (set! pos-x-delta 0.0)
      (set! pos-y-delta 0.0)
      (set! scale-factor 1.0)
      ;(send background-color copy-from background-color-initial)
      ;(send shadow-color copy-from shadow-color-initial)
      )
    
    ))

(define about-dialog%
  (class dialog%
    (super-new [label "About A-IDE"]
               [min-width 320] [border 4] [style '(close-button)] [stretchable-width #f] [stretchable-height #f])

    ; - some fields -
    ;(define background-color (make-color 213 229 255))
    ;(define shadow-color (make-color 0 68 170))
    ;(define logo-font (make-font #:size 24 #:family 'swiss #:face "Arial, Helvetica" #:weight 'bold)) ; font family is fallback
    ;(define logo (let ([shadow-radius 10]) (inset (shadow (text "A-IDE" logo-font) shadow-radius 0 0 #:color background-color #:shadow-color shadow-color) shadow-radius)))

    ; - methods -
    (define/augment (on-close) (send logo-canvas reset-logo))
    
    ; - window construction -
    (define vertical-pane1 (new vertical-pane% [parent this]))
    
    ;(new canvas% [parent vertical-pane1] [style '(transparent no-focus)] [stretchable-height #f] [min-height (inexact->exact (pict-height logo))]
    ;     [paint-callback (lambda (canvas dc)
    ;                       (let-values ([(dc-width dc-height) (send dc get-size)])
    ;                         (draw-pict logo dc (- (/ dc-width 2) (/ (pict-width logo) 2)) 0)))])
    (define logo-canvas (new my-canvas% [parent vertical-pane1]))

    (new message% [parent vertical-pane1] [auto-resize #t]
         [label "A simple IDE for AVR programming in assembly.\nA-IDE is distributed under the terms of the MIT licence.\nAVR is a registered trademark of Microchip Technology."])
    (new message% [parent vertical-pane1] [auto-resize #t] [vert-margin 10] [color "Medium Blue"] [label "Version 0.5 \"Aquitaine\""])
    (new message% [parent vertical-pane1] [auto-resize #t] [label "©2025 A. Bossard"])
    
    ; - window initialisation -
    
    ))
