#lang racket/gui

; --- imports ---
(require "constants.rkt")

; --- exports ---
(provide view-dialog%)

; --- body ---
(define view-dialog%
  (class dialog%
    (super-new [label "View settings"] [style '(close-button)] [border 2] [stretchable-height #f])

    ; - fields -
    (define font-group (new group-box-panel% [label "Font"] [parent this] [alignment '(left top)]))
    
    (define fonts-combo (new choice% [label #f] [parent font-group] [choices (cons "(default font)" (get-face-list))]))
    (new check-box% [label "Show only monospace fonts"] [parent font-group]
         [callback (lambda (control event)
                     (send fonts-combo clear)
                     (let ([names (cons "(default font)" (get-face-list (if (send control get-value) 'mono 'all)))])
                       (for-each (lambda (name) (send fonts-combo append name)) names)))])

    (define size-slider (new slider% [label "Size (pt):"] [parent font-group] [min-value 6] [max-value 28]
                             [init-value (let ([saved-font-size (get-preference 'font-size (lambda () default-font-size) 'timestamp preferences-filename)])
                                           (if (<= 6 saved-font-size 28) saved-font-size default-font-size))]))
    ; since font size in points (ie. not in pixels), it is bounded to a byte (255)

    (define colour-group (new group-box-panel% [label "Colours"] [parent this] [alignment '(left top)]))

    (define panel-h1 (new horizontal-panel% [parent colour-group] [alignment '(right center)]))
    (new message% [parent panel-h1] [label "Edit pane normal text:"])
    (define edit-foreground (new canvas% [parent panel-h1] [style '(no-focus)] [horiz-margin 5] [min-width 20] [min-height 20] [stretchable-width #f] [stretchable-height #f]))
    (new button% [label "..."] [parent panel-h1]
         [callback (lambda (button event)
                     (let ([selected-color (get-color-from-user "Edit pane normal text" this (send edit-foreground get-canvas-background))])
                       (when selected-color
                         (send edit-foreground set-canvas-background selected-color)
                         (send edit-foreground refresh-now))))])
    
    (define panel-h2 (new horizontal-panel% [parent colour-group] [alignment '(right center)]))
    (new message% [parent panel-h2] [label "Edit pane background:"])
    (define edit-background (new canvas% [parent panel-h2] [style '(no-focus)] [horiz-margin 5] [min-width 20] [min-height 20] [stretchable-width #f] [stretchable-height #f]))
    (new button% [label "..."] [parent panel-h2]
         [callback (lambda (button event)
                     (let ([selected-color (get-color-from-user "Edit pane background colour" this (send edit-background get-canvas-background))])
                       (when selected-color
                         (send edit-background set-canvas-background selected-color)
                         (send edit-background refresh-now))))])
    
    (define panel-h3 (new horizontal-panel% [parent colour-group] [alignment '(right center)]))
    (new message% [parent panel-h3] [label "Output pane normal text:"])
    (define output-foreground (new canvas% [parent panel-h3] [style '(no-focus)] [horiz-margin 5] [min-width 20] [min-height 20] [stretchable-width #f] [stretchable-height #f]))
    (new button% [label "..."] [parent panel-h3]
         [callback (lambda (button event)
                     (let ([selected-color (get-color-from-user "Output pane normal text" this (send output-foreground get-canvas-background))])
                       (when selected-color
                         (send output-foreground set-canvas-background selected-color)
                         (send output-foreground refresh-now))))])

    (define panel-h4 (new horizontal-panel% [parent colour-group] [alignment '(right center)]))
    (new message% [parent panel-h4] [label "Output pane background:"])
    (define output-background (new canvas% [parent panel-h4] [style '(no-focus)] [horiz-margin 5] [min-width 20] [min-height 20] [stretchable-width #f] [stretchable-height #f]))
    (new button% [label "..."] [parent panel-h4]
         [callback (lambda (button event)
                     (let ([selected-color (get-color-from-user "Output pane background colour" this (send output-background get-canvas-background))])
                       (when selected-color
                         (send output-background set-canvas-background selected-color)
                         (send output-background refresh-now))))])
    
    (new message% [parent this] [color "Medium Blue"] [label "(Restart A-IDE to apply changes.)"])    
    (new button% [label "Save and close"] [parent this] [style '(border)] [callback (lambda (button event) (send this show #f))])
    
    ; - methods -
    (define/public (get-font-face)
      (let ([font-index (send fonts-combo get-selection)])
        (if (= font-index 0) "" ; default font
            (send fonts-combo get-string font-index))))
    (define/public (get-font-size) (send size-slider get-value))
    (define/public (get-edit-foreground) (send edit-foreground get-canvas-background))
    (define/public (get-edit-background) (send edit-background get-canvas-background))
    (define/public (get-output-foreground) (send output-foreground get-canvas-background))
    (define/public (get-output-background) (send output-background get-canvas-background))
    
    ; - initialisation -
    ; This is called only when the dialog is instantiated. When it is hidden then shown, this is not called.
    (let* ([saved-font-face (get-preference 'font-face (lambda () default-font-face) 'timestamp preferences-filename)]
           [font-index (send fonts-combo find-string saved-font-face)])
      (if font-index
          (send fonts-combo set-selection font-index)
          (send fonts-combo set-selection 0))) ;(get-family-builtin-face 'modern)

    (send edit-foreground set-canvas-background (apply make-color (get-preference 'edit-foreground (lambda () default-edit-foreground) 'timestamp preferences-filename)))
    (send edit-background set-canvas-background (apply make-color (get-preference 'edit-background (lambda () default-edit-background) 'timestamp preferences-filename)))
    (send output-foreground set-canvas-background (apply make-color (get-preference 'output-foreground (lambda () default-output-foreground) 'timestamp preferences-filename)))
    (send output-background set-canvas-background (apply make-color (get-preference 'output-background (lambda () default-output-background) 'timestamp preferences-filename)))
    
    ))