#lang racket/gui

; --- imports ---
(require "constants.rkt")

; --- exports ---
(provide preferences-dialog%)

; --- body ---
(define preferences-dialog%
  (class dialog%
    (super-new [label "Preferences"] [width 400] [style '(close-button)] [border 2] [stretchable-height #f])

    ; - fields -
    (define paths-group (new group-box-panel% [label "Paths"] [parent this] [alignment '(left top)]))

    (define horizontal-pane1 (new horizontal-pane% [parent paths-group]))
    (define avr-as (new text-field% [label "avr-as:"] [parent horizontal-pane1] [callback (lambda (edit event) (when (eq? (send event get-event-type) 'text-field) (validate-path edit)))]))
    (new button% [label "..."] [parent horizontal-pane1]
         [callback (lambda (button event) (let ([path (get-file "Select avr-as" this)]) (when path (send avr-as set-value (path->string path)) (validate-path avr-as))))])

    (define horizontal-pane2 (new horizontal-pane% [parent paths-group]))
    (define avr-ld (new text-field% [label "avr-ld:"] [parent horizontal-pane2] [callback (lambda (edit event) (when (eq? (send event get-event-type) 'text-field) (validate-path edit)))]))
    (new button% [label "..."] [parent horizontal-pane2]
         [callback (lambda (button event) (let ([path (get-file "Select avr-ld" this)]) (when path (send avr-ld set-value (path->string path)) (validate-path avr-ld))))])

    (define horizontal-pane3 (new horizontal-pane% [parent paths-group]))
    (define avr-objcopy (new text-field% [label "avr-objcopy:"] [parent horizontal-pane3] [callback (lambda (edit event) (when (eq? (send event get-event-type) 'text-field) (validate-path edit)))]))
    (new button% [label "..."] [parent horizontal-pane3]
         [callback (lambda (button event) (let ([path (get-file "Select avr-objcopy" this)]) (when path (send avr-objcopy set-value (path->string path)) (validate-path avr-objcopy))))])

    (define horizontal-pane4 (new horizontal-pane% [parent paths-group]))
    (define avr-size (new text-field% [label "avr-size:"] [parent horizontal-pane4] [callback (lambda (edit event) (when (eq? (send event get-event-type) 'text-field) (validate-path edit)))]))
    (new button% [label "..."] [parent horizontal-pane4]
         [callback (lambda (button event) (let ([path (get-file "Select avr-size" this)]) (when path (send avr-size set-value (path->string path)) (validate-path avr-size))))])

    (define horizontal-pane5 (new horizontal-pane% [parent paths-group]))
    (define avrdude (new text-field% [label "avrdude:"] [parent horizontal-pane5] [callback (lambda (edit event) (when (eq? (send event get-event-type) 'text-field) (validate-path edit)))]))
    (new button% [label "..."] [parent horizontal-pane5]
         [callback (lambda (button event) (let ([path (get-file "Select avrdude" this)]) (when path (send avrdude set-value (path->string path)) (validate-path avrdude))))])

    (define horizontal-pane6 (new horizontal-pane% [parent paths-group]))
    (define avrdude-conf (new text-field% [label "avrdude.conf:"] [parent horizontal-pane6] [callback (lambda (edit event) (when (eq? (send event get-event-type) 'text-field) (validate-path edit)))]))
    (new button% [label "..."] [parent horizontal-pane6]
         [callback (lambda (button event) (let ([path (get-file "Select avrdude.conf" this)]) (when path (send avrdude-conf set-value (path->string path)) (validate-path avrdude-conf))))])

    (define parameters-group (new group-box-panel% [label "Parameters"] [parent this] [alignment '(left top)]))
    (define avr-as-isa-mcu (new choice% [label "avr-as ISA/MCU: "] [parent parameters-group] [choices avr-as-isa-mcus] [stretchable-width #t]))
    (define avrdude-part (new choice% [label "avrdude MCU: "] [parent parameters-group] [choices (map cdr avrdude-parts)] [stretchable-width #t]))
    (define avrdude-programmer (new choice% [label "programmer: "] [parent parameters-group] [choices avrdude-programmers] [stretchable-width #t]))
    (define port (new text-field% [label "Port:"] [parent parameters-group]))

    (new button% [label "Save and close"] [parent this] [style '(border)] [callback (lambda (button event) (send this show #f))])
    
    ; - methods -
    (define (validate-path edit) ; Edit has a green background if the path points to an existing file, red otherwise.
      (let ([str (send edit get-value)])
        (if (and (non-empty-string? str) (find-executable-path str))
            (send edit set-field-background (send the-color-database find-color "LightGreen"))
            (send edit set-field-background (send the-color-database find-color "LightPink")))))

    (define/public (get-avr-as) (send avr-as get-value))
    (define/public (get-avr-ld) (send avr-ld get-value))
    (define/public (get-avr-objcopy) (send avr-objcopy get-value))
    (define/public (get-avr-size) (send avr-size get-value))
    (define/public (get-avrdude) (send avrdude get-value))
    (define/public (get-avrdude-conf) (send avrdude-conf get-value))
    (define/public (get-avr-as-isa-mcu) (send avr-as-isa-mcu get-selection))
    (define/public (get-avr-as-isa-mcu-string) (send avr-as-isa-mcu get-string-selection))
    (define/public (get-avrdude-part) (send avrdude-part get-selection))
    (define/public (get-avrdude-programmer) (send avrdude-programmer get-selection))
    (define/public (get-avrdude-programmer-string) (send avrdude-programmer get-string-selection))
    (define/public (get-port) (send port get-value))
    
    ; - initialisation -
    ; (do this here since init-value sets min-width and thus text fields would look strange)
    ; This is called only when the dialog is instantiated. When it is hidden then shown, it is not called.
    (send avr-as set-value (get-preference 'avr-as (lambda () default-avr-as) 'timestamp preferences-filename))
    (validate-path avr-as)
    (send avr-ld set-value (get-preference 'avr-ld (lambda () default-avr-ld) 'timestamp preferences-filename))
    (validate-path avr-ld)
    (send avr-objcopy set-value (get-preference 'avr-objcopy (lambda () default-avr-objcopy) 'timestamp preferences-filename))
    (validate-path avr-objcopy)
    (send avr-size set-value (get-preference 'avr-size (lambda () default-avr-size) 'timestamp preferences-filename))
    (validate-path avr-size)
    (send avrdude set-value (get-preference 'avrdude (lambda () default-avrdude) 'timestamp preferences-filename))
    (validate-path avrdude)
    (send avrdude-conf set-value (get-preference 'avrdude-conf (lambda () default-avrdude-conf) 'timestamp preferences-filename))
    (validate-path avrdude-conf)
    (send avr-as-isa-mcu set-selection (get-preference 'avr-as-isa-mcu (lambda () default-avr-as-isa-mcu) 'timestamp preferences-filename))
    (send avrdude-part set-selection (get-preference 'avrdude-part (lambda () default-avrdude-part) 'timestamp preferences-filename))
    (send avrdude-programmer set-selection (get-preference 'avrdude-programmer (lambda () default-avrdude-programmer) 'timestamp preferences-filename))
    (send port set-value (get-preference 'avr-port (lambda () default-port) 'timestamp preferences-filename))
    
    ))
