#lang racket/gui

; --- exports ---
(provide line-message%)

; --- body ---
(define line-message% ; updates line number only when needed to reduce flickering
  (class message%
    (define line-number 1)
    (super-new [label (number->string line-number)]
               [auto-resize #t] ; if auto-resize, the build message is can move a bit when the number of digits of the line number changes
               ;[min-width 10] ; thanks to min-width, the line-number message does not grow often
               )
    
    ; - methods -
    (define/public (set-when-needed number)
      (when (not (= line-number number))
        (set! line-number number)
        (send this set-label (number->string line-number))))
    
    ))
