#lang racket/gui

; --- imports ---
(require "ide-editor.rkt")
(require "constants.rkt")

; --- exports ---
(provide tab%)

; --- body ---
(define tab% ; class representing a tab: its editor, saved/unsaved state, title
  (class editor-canvas%
    (init frame
          tab-panel
          tab-id
          [tab-title default-tab-title])
    (super-new [parent tab-panel]
               [editor (new ide-editor% [frame frame] [tab this])]
               [style '(deleted auto-hscroll)])
  
    ; - fields -
    ;(define parent-frame frame) ; 'frame' not used in a method, so no need to add a field for it
    (define parent-tab-panel tab-panel)
    (define id tab-id)
    (define title tab-title)
    
    (define marker-set #f)
    (define marker "💾 ")
    
    ; - methods -
    (define/public (set-id tab-id) (set! id tab-id)) ; used by parent-tab-panel to update the id stored by tab% instances
    
    (define/public (get-title) title)
    (define (set-title t)
      (set! title t)
      (send parent-tab-panel set-item-label id title))

    (define/public (set-title-and-reset-marker t)
      (set-title t)
      (set! marker-set #f))
        
    (define/public (set-marker-when-unset) ; set tab title only when needed, this avoids flickering
      (when (not marker-set)
        (set! marker-set #t)
        (set-title (string-append marker title))))
  
    ; - initial actions -
    (send this set-canvas-background (send frame get-edit-background))
    
    ))

