#lang racket

; --- imports ---
(require racket/draw)

; --- exports ---
(provide default-tab-title
         preferences-filename

         frame-default-x
         frame-default-y
         frame-default-width
         frame-default-height
         frame-default-percentages
         default-output-shown
         default-linewrap
         default-font-face
         default-font-size
         default-edit-foreground
         default-edit-background
         default-output-foreground
         default-output-background

         default-avr-as-isa-mcu
         default-avr-as
         avr-as-parameters
         default-avr-ld
         avr-ld-parameters
         default-avr-objcopy
         avr-objcopy-parameters
         default-port
         default-avrdude-part
         default-avrdude-programmer
         default-avrdude
         default-avrdude-conf
         avrdude-parameters
         default-avr-size
         avr-size-parameters

         avr-as-isa-mcus
         avrdude-parts
         avrdude-programmers         
         )

; --- body ---

; - strings -
(define default-tab-title "(new buffer)")
(define preferences-filename "settings.txt")

; - view -
(define frame-default-x 10)
(define frame-default-y 10)
(define frame-default-width 640)
(define frame-default-height 480)
(define frame-default-percentages '(70/100 30/100))
(define default-output-shown #t)
(define default-linewrap #t)
(define default-font-face "")
(define default-font-size 11)
(define default-edit-foreground '(0 0 0))
(define default-edit-background '(255 255 255))
(define default-output-foreground '(0 0 0))
(define default-output-background '(220 220 220))

; - build & upload -
(define default-avr-as-isa-mcu 133)
(define default-avr-as "avr-as")
(define (avr-as-parameters mcu path-dir path-o path-s) (list (string-append "-mmcu=" mcu) "-I" path-dir "-o" path-o path-s))
(define default-avr-ld "avr-ld")
(define (avr-ld-parameters path-elf path-o) (list "-m" "avr5" "-o" path-elf path-o))
(define default-avr-objcopy "avr-objcopy")
(define (avr-objcopy-parameters path-elf path-hex) (list "-O" "ihex" "-R" ".eeprom" path-elf path-hex))
(define default-avr-size "avr-size")
(define (avr-size-parameters path-elf) (list "-A" path-elf))
(define default-port "COM3")
(define default-avrdude-part 60)
(define default-avrdude-programmer 2)
(define default-avrdude "avrdude")
(define default-avrdude-conf "/etc/avrdude.conf")
(define (avrdude-parameters path-conf part programmer com-port path-hex)
  (list "-C" path-conf "-p" part "-c" programmer "-P" com-port "-b" "115200" "-D" "-U" (string-append "flash:w:" (path->string path-hex) ":i")))

(define avr-as-isa-mcus
  '("avr2"
    "attiny22" "attiny26" "at90s2313" "at90s2323" "at90s2333" "at90s2343" "at90s4414" "at90s4433" "at90s4434" "at90c8534" "at90s8515" "at90s8535"
    "avr25"
    "attiny13" "attiny13a" "attiny24" "attiny24a" "attiny25" "attiny261" "attiny261a" "attiny2313" "attiny2313a" "attiny43u" "attiny44" "attiny44a" "attiny45" "attiny48" "attiny441" "attiny461" "attiny461a" "attiny4313" "attiny84" "attiny84a" "attiny85" "attiny87" "attiny88" "attiny828" "attiny841" "attiny861" "attiny861a" "ata5272" "ata6616c" "at86rf401"
    "avr3"
    "at76c711" "at43usb355"
    "avr31"
    "atmega103" "at43usb320"
    "avr35"
    "attiny167" "attiny1634" "atmega8u2" "atmega16u2" "atmega32u2" "ata5505" "ata6617c" "ata664251" "at90usb82" "at90usb162"
    "avr4"
    "atmega48" "atmega48a" "atmega48p" "atmega48pa" "atmega48pb" "atmega8" "atmega8a" "atmega8hva" "atmega88" "atmega88a" "atmega88p" "atmega88pa" "atmega88pb" "atmega8515" "atmega8535" "ata6285" "ata6286" "ata6289" "ata6612c" "at90pwm1" "at90pwm2" "at90pwm2b" "at90pwm3" "at90pwm3b" "at90pwm81"
    "avr5"
    "atmega16" "atmega16a" "atmega16hva" "atmega16hva2" "atmega16hvb" "atmega16hvbrevb" "atmega16m1" "atmega16u4" "atmega161" "atmega162" "atmega163" "atmega164a" "atmega164p" "atmega164pa" "atmega165" "atmega165a" "atmega165p" "atmega165pa" "atmega168" "atmega168a" "atmega168p" "atmega168pa" "atmega168pb" "atmega169" "atmega169a" "atmega169p" "atmega169pa" "atmega32" "atmega32a" "atmega32c1" "atmega32hvb" "atmega32hvbrevb" "atmega32m1" "atmega32u4" "atmega32u6" "atmega323" "atmega324a" "atmega324p" "atmega324pa" "atmega324pb" "atmega325" "atmega325a" "atmega325p" "atmega325pa" "atmega328" "atmega328p" "atmega328pb" "atmega329" "atmega329a" "atmega329p" "atmega329pa" "atmega3250" "atmega3250a" "atmega3250p" "atmega3250pa" "atmega3290" "atmega3290a" "atmega3290p" "atmega3290pa" "atmega406" "atmega64" "atmega64a" "atmega64c1" "atmega64hve" "atmega64hve2" "atmega64m1" "atmega64rfr2" "atmega640" "atmega644" "atmega644a" "atmega644p" "atmega644pa" "atmega644rfr2" "atmega645" "atmega645a" "atmega645p" "atmega649" "atmega649a" "atmega649p" "atmega6450" "atmega6450a" "atmega6450p" "atmega6490" "atmega6490a" "atmega6490p" "ata5795" "ata5790" "ata5790n" "ata5791" "ata6613c" "ata6614q" "ata5782" "ata5831" "ata8210" "ata8510" "ata5702m322" "at90pwm161" "at90pwm216" "at90pwm316" "at90can32" "at90can64" "at90scr100" "at90usb646" "at90usb647" "at94k" "m3000"
    "avr51"
    "atmega128" "atmega128a" "atmega128rfa1" "atmega128rfr2" "atmega1280" "atmega1281" "atmega1284" "atmega1284p" "atmega1284rfr2" "at90can128" "at90usb1286" "at90usb1287"
    "avr6"
    "atmega256rfr2" "atmega2560" "atmega2561" "atmega2564rfr2"
    "avrxmega2"
    "atxmega8e5" "atxmega16a4" "atxmega16a4u" "atxmega16c4" "atxmega16d4" "atxmega16e5" "atxmega32a4" "atxmega32a4u" "atxmega32c3" "atxmega32c4" "atxmega32d3" "atxmega32d4" "atxmega32e5"
    "avrxmega3"
    "attiny202" "attiny204" "attiny212" "attiny214" "attiny402" "attiny404" "attiny406" "attiny412" "attiny414" "attiny416" "attiny417" "attiny804" "attiny806" "attiny807" "attiny814" "attiny816" "attiny817" "attiny1604" "attiny1606" "attiny1607" "attiny1614" "attiny1616" "attiny1617" "attiny3214" "attiny3216" "attiny3217" "atmega808" "atmega809" "atmega1608" "atmega1609" "atmega3208" "atmega3209" "atmega4808" "atmega4809"
    "avrxmega4"
    "atxmega64a3" "atxmega64a3u" "atxmega64a4u" "atxmega64b1" "atxmega64b3" "atxmega64c3" "atxmega64d3" "atxmega64d4"
    "avrxmega5"
    "atxmega64a1" "atxmega64a1u"
    "avrxmega6"
    "atxmega128a3" "atxmega128a3u" "atxmega128b1" "atxmega128b3" "atxmega128c3" "atxmega128d3" "atxmega128d4" "atxmega192a3" "atxmega192a3u" "atxmega192c3" "atxmega192d3" "atxmega256a3" "atxmega256a3b" "atxmega256a3bu" "atxmega256a3u" "atxmega256c3" "atxmega256d3" "atxmega384c3" "atxmega384d3"
    "avrxmega7"
    "atxmega128a1" "atxmega128a1u" "atxmega128a4u"
    "avrtiny"
    "attiny4" "attiny5" "attiny9" "attiny10" "attiny20" "attiny40"
    "avr1"
    "attiny11" "attiny12" "attiny15" "attiny28" "at90s1200"
    ))

(define avrdude-parts
  '(("uc3a0512" . "AT32UC3A0512")
    ("c128" . "AT90CAN128")
    ("c32" . "AT90CAN32")
    ("c64" . "AT90CAN64")
    ("pwm2" . "AT90PWM2")
    ("pwm216" . "AT90PWM216")
    ("pwm2b" . "AT90PWM2B")
    ("pwm3" . "AT90PWM3")
    ("pwm316" . "AT90PWM316")
    ("pwm3b" . "AT90PWM3B")
    ("1200" . "AT90S1200")
    ("2313" . "AT90S2313")
    ("2333" . "AT90S2333")
    ("2343" . "AT90S2343")
    ("4414" . "AT90S4414")
    ("4433" . "AT90S4433")
    ("4434" . "AT90S4434")
    ("8515" . "AT90S8515")
    ("8535" . "AT90S8535")
    ("usb1286" . "AT90USB1286")
    ("usb1287" . "AT90USB1287")
    ("usb162" . "AT90USB162")
    ("usb646" . "AT90USB646")
    ("usb647" . "AT90USB647")
    ("usb82" . "AT90USB82")
    ("m103" . "ATmega103")
    ("m128" . "ATmega128")
    ("m1280" . "ATmega1280")
    ("m1281" . "ATmega1281")
    ("m1284" . "ATmega1284")
    ("m1284p" . "ATmega1284P")
    ("m1284rfr2" . "ATmega1284RFR2")
    ("m128rfa1" . "ATmega128RFA1")
    ("m128rfr2" . "ATmega128RFR2")
    ("m16" . "ATmega16")
    ("m1608" . "ATmega1608")
    ("m1609" . "ATmega1609")
    ("m161" . "ATmega161")
    ("m162" . "ATmega162")
    ("m163" . "ATmega163")
    ("m164p" . "ATmega164P")
    ("m168" . "ATmega168")
    ("m168p" . "ATmega168P")
    ("m168pb" . "ATmega168PB")
    ("m169" . "ATmega169")
    ("m16u2" . "ATmega16U2")
    ("m2560" . "ATmega2560")
    ("m2561" . "ATmega2561")
    ("m2564rfr2" . "ATmega2564RFR2")
    ("m256rfr2" . "ATmega256RFR2")
    ("m32" . "ATmega32")
    ("m3208" . "ATmega3208")
    ("m3209" . "ATmega3209")
    ("m324a" . "ATmega324A")
    ("m324p" . "ATmega324P")
    ("m324pa" . "ATmega324PA")
    ("m324pb" . "ATmega324PB")
    ("m325" . "ATmega325")
    ("m3250" . "ATmega3250")
    ("m328" . "ATmega328")
    ("m328p" . "ATmega328P")
    ("m328pb" . "ATmega328PB")
    ("m329" . "ATmega329")
    ("m3290" . "ATmega3290")
    ("m3290p" . "ATmega3290P")
    ("m329p" . "ATmega329P")
    ("m32m1" . "ATmega32M1")
    ("m32u2" . "ATmega32U2")
    ("m32u4" . "ATmega32U4")
    ("m406" . "ATMEGA406")
    ("m48" . "ATmega48")
    ("m4808" . "ATmega4808")
    ("m4809" . "ATmega4809")
    ("m48p" . "ATmega48P")
    ("m48pb" . "ATmega48PB")
    ("m64" . "ATmega64")
    ("m640" . "ATmega640")
    ("m644" . "ATmega644")
    ("m644p" . "ATmega644P")
    ("m644rfr2" . "ATmega644RFR2")
    ("m645" . "ATmega645")
    ("m6450" . "ATmega6450")
    ("m649" . "ATmega649")
    ("m6490" . "ATmega6490")
    ("m64m1" . "ATmega64M1")
    ("m64rfr2" . "ATmega64RFR2")
    ("m8" . "ATmega8")
    ("m808" . "ATmega808")
    ("m809" . "ATmega809")
    ("m8515" . "ATmega8515")
    ("m8535" . "ATmega8535")
    ("m88" . "ATmega88")
    ("m88p" . "ATmega88P")
    ("m88pb" . "ATmega88PB")
    ("m8a" . "ATmega8A")
    ("m8u2" . "ATmega8U2")
    ("t10" . "ATtiny10")
    ("t11" . "ATtiny11")
    ("t12" . "ATtiny12")
    ("t13" . "ATtiny13")
    ("t15" . "ATtiny15")
    ("t1604" . "ATtiny1604")
    ("t1606" . "ATtiny1606")
    ("t1607" . "ATtiny1607")
    ("t1614" . "ATtiny1614")
    ("t1616" . "ATtiny1616")
    ("t1617" . "ATtiny1617")
    ("t1624" . "ATtiny1624")
    ("t1626" . "ATtiny1626")
    ("t1627" . "ATtiny1627")
    ("t1634" . "ATtiny1634")
    ("t20" . "ATtiny20")
    ("t202" . "ATtiny202")
    ("t204" . "ATtiny204")
    ("t212" . "ATtiny212")
    ("t214" . "ATtiny214")
    ("t2313" . "ATtiny2313")
    ("t24" . "ATtiny24")
    ("t25" . "ATtiny25")
    ("t26" . "ATtiny26")
    ("t261" . "ATtiny261")
    ("t28" . "ATtiny28")
    ("t3216" . "ATtiny3216")
    ("t3217" . "ATtiny3217")
    ("t4" . "ATtiny4")
    ("t40" . "ATtiny40")
    ("t402" . "ATtiny402")
    ("t404" . "ATtiny404")
    ("t406" . "ATtiny406")
    ("t412" . "ATtiny412")
    ("t414" . "ATtiny414")
    ("t416" . "ATtiny416")
    ("t417" . "ATtiny417")
    ("t424" . "ATtiny424")
    ("t426" . "ATtiny426")
    ("t427" . "ATtiny427")
    ("t4313" . "ATtiny4313")
    ("t43u" . "ATtiny43u")
    ("t44" . "ATtiny44")
    ("t441" . "ATtiny441")
    ("t45" . "ATtiny45")
    ("t461" . "ATtiny461")
    ("t5" . "ATtiny5")
    ("t804" . "ATtiny804")
    ("t806" . "ATtiny806")
    ("t807" . "ATtiny807")
    ("t814" . "ATtiny814")
    ("t816" . "ATtiny816")
    ("t817" . "ATtiny817")
    ("t824" . "ATtiny824")
    ("t826" . "ATtiny826")
    ("t827" . "ATtiny827")
    ("t84" . "ATtiny84")
    ("t841" . "ATtiny841")
    ("t85" . "ATtiny85")
    ("t861" . "ATtiny861")
    ("t88" . "ATtiny88")
    ("t9" . "ATtiny9")
    ("x128a1" . "ATxmega128A1")
    ("x128a1d" . "ATxmega128A1revD")
    ("x128a1u" . "ATxmega128A1U")
    ("x128a3" . "ATxmega128A3")
    ("x128a3u" . "ATxmega128A3U")
    ("x128a4" . "ATxmega128A4")
    ("x128a4u" . "ATxmega128A4U")
    ("x128b1" . "ATxmega128B1")
    ("x128b3" . "ATxmega128B3")
    ("x128c3" . "ATxmega128C3")
    ("x128d3" . "ATxmega128D3")
    ("x128d4" . "ATxmega128D4")
    ("x16a4" . "ATxmega16A4")
    ("x16a4u" . "ATxmega16A4U")
    ("x16c4" . "ATxmega16C4")
    ("x16d4" . "ATxmega16D4")
    ("x16e5" . "ATxmega16E5")
    ("x192a1" . "ATxmega192A1")
    ("x192a3" . "ATxmega192A3")
    ("x192a3u" . "ATxmega192A3U")
    ("x192c3" . "ATxmega192C3")
    ("x192d3" . "ATxmega192D3")
    ("x256a1" . "ATxmega256A1")
    ("x256a3" . "ATxmega256A3")
    ("x256a3b" . "ATxmega256A3B")
    ("x256a3bu" . "ATxmega256A3BU")
    ("x256a3u" . "ATxmega256A3U")
    ("x256c3" . "ATxmega256C3")
    ("x256d3" . "ATxmega256D3")
    ("x32a4" . "ATxmega32A4")
    ("x32a4u" . "ATxmega32A4U")
    ("x32c4" . "ATxmega32C4")
    ("x32d4" . "ATxmega32D4")
    ("x32e5" . "ATxmega32E5")
    ("x384c3" . "ATxmega384C3")
    ("x384d3" . "ATxmega384D3")
    ("x64a1" . "ATxmega64A1")
    ("x64a1u" . "ATxmega64A1U")
    ("x64a3" . "ATxmega64A3")
    ("x64a3u" . "ATxmega64A3U")
    ("x64a4" . "ATxmega64A4")
    ("x64a4u" . "ATxmega64A4U")
    ("x64b1" . "ATxmega64B1")
    ("x64b3" . "ATxmega64B3")
    ("x64c3" . "ATxmega64C3")
    ("x64d3" . "ATxmega64D3")
    ("x64d4" . "ATxmega64D4")
    ("x8e5" . "ATxmega8E5")
    ("avr128da28" . "AVR128DA28")
    ("avr128da32" . "AVR128DA32")
    ("avr128da48" . "AVR128DA48")
    ("avr128da64" . "AVR128DA64")
    ("avr128db28" . "AVR128DB28")
    ("avr128db32" . "AVR128DB32")
    ("avr128db48" . "AVR128DB48")
    ("avr128db64" . "AVR128DB64")
    ("avr32da28" . "AVR32DA28")
    ("avr32da32" . "AVR32DA32")
    ("avr32da48" . "AVR32DA48")
    ("avr32db28" . "AVR32DB28")
    ("avr32db32" . "AVR32DB32")
    ("avr32db48" . "AVR32DB48")
    ("avr64da28" . "AVR64DA28")
    ("avr64da32" . "AVR64DA32")
    ("avr64da48" . "AVR64DA48")
    ("avr64da64" . "AVR64DA64")
    ("avr64db28" . "AVR64DB28")
    ("avr64db32" . "AVR64DB32")
    ("avr64db48" . "AVR64DB48")
    ("avr64db64" . "AVR64DB64")
    ("lgt8fx168p" . "LGT8FX168P")
    ("lgt8fx328p" . "LGT8FX328P")
    ("lgt8fx88p" . "LGT8FX88P")
    ))

(define avrdude-programmers
  '("2232HIO"
    "4232h"
    "arduino"
    "arduino-ft232r"
    "atmelice"
    "atmelice_dw"
    "atmelice_isp"
    "atmelice_pdi"
    "atmelice_updi"
    "avr109"
    "avr910"
    "avr911"
    "avrftdi"
    "avrisp"
    "avrisp2"
    "avrispmkII"
    "avrispv2"
    "buspirate"
    "buspirate_bb"
    "butterfly"
    "butterfly_mk"
    "bwmega"
    "C232HM"
    "c2n232i"
    "dasa"
    "dasa3"
    "diecimila"
    "dragon_dw"
    "dragon_hvsp"
    "dragon_isp"
    "dragon_jtag"
    "dragon_pdi"
    "dragon_pp"
    "ehajo-isp"
    "flip1"
    "flip2"
    "ft232r"
    "ft245r"
    "iseavrprog"
    "jtag1"
    "jtag1slow"
    "jtag2"
    "jtag2avr32"
    "jtag2dw"
    "jtag2fast"
    "jtag2isp"
    "jtag2pdi"
    "jtag2slow"
    "jtag3"
    "jtag3dw"
    "jtag3isp"
    "jtag3pdi"
    "jtag3updi"
    "jtagkey"
    "jtagmkI"
    "jtagmkII"
    "jtagmkII_avr32"
    "lm3s811"
    "mib510"
    "mkbutterfly"
    "nibobee"
    "o-link"
    "openmoko"
    "pavr"
    "pickit2"
    "pickit4_updi"
    "pkobn_updi"
    "ponyser"
    "powerdebugger"
    "powerdebugger_dw"
    "powerdebugger_isp"
    "powerdebugger_pdi"
    "powerdebugger_updi"
    "siprog"
    "snap_updi"
    "stk500"
    "stk500hvsp"
    "stk500pp"
    "stk500v1"
    "stk500v2"
    "stk600"
    "stk600hvsp"
    "stk600pp"
    "tc2030"
    "ttl232r"
    "tumpa"
    "UM232H"
    "uncompatino"
    "usbasp"
    "usbasp-clone"
    "usbtiny"
    "wiring"
    "xbee"
    "xplainedmini"
    "xplainedmini_dw"
    "xplainedmini_updi"
    "xplainedpro"
    "xplainedpro_updi"
    ))